LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY and2 IS
  PORT( a, b : in std_logic;
        c : out std_logic );
END and2;

ARCHITECTURE behave OF and2 IS
BEGIN
  c <= a and b;
END behave;

CONFIGURATION and2con OF and2 IS
  FOR behave
  END FOR;
END and2con;


LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY struc_and3 IS
  PORT( I1, I2, I3 : IN std_logic;
        O1 : OUT std_logic);
END struc_and3;

ARCHITECTURE structural OF struc_and3 IS
  COMPONENT and2
    PORT( a, b : in std_logic;
          c : out std_logic );
  END COMPONENT;

  SIGNAL s1 : std_logic;

BEGIN

  x1 : and2
    PORT MAP( a => I1, b => I2, c => s1 );

  x2 : and2
    PORT MAP( a => I3, b => s1, c => O1 );

END structural;



CONFIGURATION and3strc_con OF struc_and3 IS
  FOR structural
    FOR x1 : and2 USE CONFIGURATION WORK.and2con;
    END FOR;

    FOR x2 : and2 USE CONFIGURATION WORK.and2con;
    END FOR;

  END FOR;
END and3strc_con;



CONFIGURATION decode_map_con OF decode IS
  FOR structural
    FOR ALL : inv USE ENTITY WORK.inv(behave);
    END FOR;

    FOR A1 : and3 USE ENTITY WORK.struc_and3(structural)
      PORT MAP( I1 => a1, I2 => a2, I3 => a3, o1 => O1);
    END FOR;

    FOR OTHERS : and3 USE ENTITY WORK.and3(behave);
    END FOR;

  END FOR;
END decode_map_con;


